/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.type.integration;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.TeamData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopQuestEntryType
extends AbstractShopEntryType {
    public String questID = "";
    private ItemStack iconPath = Items.f_42127_.m_7968_();
    private boolean useIconFromQuest = true;

    public ShopQuestEntryType(String questID) {
        this.questID = questID;
    }

    @Override
    public void getConfig(ConfigGroup configGroup) {
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopQuestEntryType(this.questID);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.integration.quest");
    }

    @Override
    public String getModNameForContextMenu() {
        return "FTB Quests";
    }

    @Override
    public List<Component> getDescriptionForContextMenu() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.m_237115_((String)"sdmr.shop.entry.creator.type.questType.description"));
        list.add((Component)Component.m_237115_((String)"sdmr.shop.entry.creator.type.questType.description_1"));
        return list;
    }

    @Override
    public boolean isCountable() {
        return false;
    }

    @Override
    public String getModId() {
        return "ftbquests";
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128359_("questID", this.questID);
        NBTUtils.putItemStack(nbt, "iconPathNew", this.iconPath);
        nbt.m_128379_("useIconFromQuest", this.useIconFromQuest);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.questID = nbt.m_128461_("questID");
        this.iconPath = NBTUtils.getItemStack(nbt, "iconPathNew");
        this.useIconFromQuest = nbt.m_128471_("useIconFromQuest");
    }

    @Override
    public String getId() {
        return "questType";
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        TeamData data = TeamData.get((Player)player);
        Quest quest = ClientQuestFile.INSTANCE.getQuest(QuestObjectBase.parseCodeString((String)this.questID));
        if (quest == null) {
            return;
        }
        if (data.isCompleted((QuestObject)quest)) {
            data.setCompleted(QuestObjectBase.parseCodeString((String)this.questID), null);
            SDMShopR.setMoney(player, SDMShopR.getMoney(player) + entry.entryPrice);
        }
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        TeamData data = TeamData.get((Player)player);
        Quest quest = ClientQuestFile.INSTANCE.getQuest(QuestObjectBase.parseCodeString((String)this.questID));
        if (quest == null) {
            return;
        }
        if (!data.isCompleted((QuestObject)quest)) {
            data.setCompleted(QuestObjectBase.parseCodeString((String)this.questID), new Date(System.currentTimeMillis()));
            SDMShopR.setMoney(player, SDMShopR.getMoney(player) - entry.entryPrice);
        }
    }

    @Override
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        TeamData data = TeamData.get((Player)player);
        Quest quest = ClientQuestFile.INSTANCE.getQuest(QuestObjectBase.parseCodeString((String)this.questID));
        if (quest != null && data.isCompleted((QuestObject)quest)) {
            return false;
        }
        long playerMoney = SDMShopR.getMoney(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L;
    }

    @Override
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        TeamData data = TeamData.get((Player)player);
        Quest quest = ClientQuestFile.INSTANCE.getQuest(QuestObjectBase.parseCodeString((String)this.questID));
        if (quest == null) {
            return 0;
        }
        if (isSell) {
            if (!data.isCompleted((QuestObject)quest)) {
                return 1;
            }
        } else {
            if (quest != null && data.isCompleted((QuestObject)quest)) {
                return 0;
            }
            long playerMoney = SDMShopR.getMoney(player);
            if (entry.entryPrice == 0L) {
                return 1;
            }
            return (int)(playerMoney / entry.entryPrice) >= 1 ? 1 : 0;
        }
        return 0;
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopQuestEntryType("");
        }
    }
}

